
package MyElements::oligo_analysis;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'urn:RSATWS' }

__PACKAGE__->__set_name('oligo_analysis');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %request_of :ATTR(:get<request>);

__PACKAGE__->_factory(
    [ qw(        request

    ) ],
    {
        'request' => \%request_of,
    },
    {
        'request' => 'MyTypes::OligoAnalysisRequest',
    },
    {

        'request' => 'request',
    }
);

} # end BLOCK






} # end of BLOCK



1;


=pod

=head1 NAME

MyElements::oligo_analysis

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
oligo_analysis from the namespace urn:RSATWS.





=head1 METHODS

=head2 new

 my $element = MyElements::oligo_analysis->new($data);

Constructor. The following data structure may be passed to new():

 {
   request =>  { # MyTypes::OligoAnalysisRequest
     output =>  $some_value, # string
     verbosity =>  $some_value, # int
     sequence =>  $some_value, # string
     tmp_infile =>  $some_value, # string
     format =>  $some_value, # string
     length =>  $some_value, # int
     organism =>  $some_value, # string
     background =>  $some_value, # string
     stats =>  $some_value, # string
     noov =>  $some_value, # int
     str =>  $some_value, # int
     sort =>  $some_value, # int
     lth =>  $some_value, # string
     uth =>  $some_value, # string
     pseudo =>  $some_value, # string
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

